<?php

/**
 * MyBB 1.6
 * Copyright 2010 MyBB Group, All Rights Reserved
 *
 * Default Avatar by Santiago Dimattia
 * http://www.teleportz.com.ar
 * 
 */

if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

$plugins->add_hook("member_do_register_end", "default_avatar_onsignup");
$plugins->add_hook("usercp_do_avatar_end", "default_avatar_onchange");
$plugins->add_hook("admin_config_settings_start", "default_avatar_update_current_users");

/**
 * Plugin information
 *
 * @return bool
 */
function default_avatar_info()
{
	global $lang;

	$lang->load('default_avatar');
	 
	$data = array(
			"name" => $lang->default_avatar_plugin_name,
			"description" => $lang->default_avatar_plugin_description,
			"website" => "http://mods.mybboard.net/view/default-avatar/",
			"author" => "Santiago Dimattia",
			"authorsite" => "http://teleportz.com.ar",
			"version" => "1.0",
			"guid" => "389824f8f3c7b9056bed9dc3ac0330da",
			"compatibility" => "16*"
		);
	
	$plugin_status = default_avatar_is_installed();

	if($plugin_status)
	{
		$data['description'] .= $lang->sprintf($lang->default_avatar_plugin_description_link, 'index.php?module=config&amp;defaultavatar=update_current_users');
	}
	
	return $data;
}

/**
 * Install plugin
 *
 * @return bool
 */
function default_avatar_install()
{
	global $db, $lang;
	
	// Create settings
	$new_configs = array();
	
	$new_configs[] = array(
		'name' => 'default_avatar_url',
		'title' => $lang->default_avatar_setting_url,
		'description' => $lang->default_avatar_setting_url_description,
		'optionscode' => 'text',
		'value' => 'images/avatars/invalid_url.gif',
		'disporder' => 40,
		'gid' => '9'
	);
	
	$new_configs[] = array(
		'name' => 'default_avatar_width',
		'title' => $lang->default_avatar_setting_width,
		'description' => $lang->default_avatar_setting_width_description,
		'optionscode' => 'text',
		'value' => '84',
		'disporder' => 41,
		'gid' => '9'
	);
	
	$new_configs[] = array(
		'name' => 'default_avatar_height',
		'title' => $lang->default_avatar_setting_height,
		'description' => $lang->default_avatar_setting_height_description,
		'optionscode' => 'text',
		'value' => '84',
		'disporder' => 42,
		'gid' => '9'
	);
	
	foreach($new_configs as $key => $data)
	{
		$db->insert_query("settings", $data);
	}
	
	rebuild_settings();
	
	return TRUE;
}

/**
 * Uninstall plugin
 *
 * @return bool
 */
function default_avatar_uninstall()
{
	global $db;
	
	$db->delete_query('settings', 'name = "default_avatar_url" OR name = "default_avatar_width" OR name = "default_avatar_height"');

	rebuild_settings();
	
	return TRUE;
}

/**
 * Check if plugin is installed
 *
 * @return bool
 */
function default_avatar_is_installed()
{
	global $mybb;
	
	// If setting exists, plugin is installed
	if(isset($mybb->settings['default_avatar_url']))
	{
		return TRUE;
	}
	
	return FALSE;
}

/**
 * Activate plugin
 *
 * @return bool
 */
function default_avatar_activate()
{
	// Delete "Delete Avatar" button
	require MYBB_ROOT . '/inc/adminfunctions_templates.php';

	find_replace_templatesets('usercp_avatar', '#' . preg_quote('<input type="submit" class="button" name="remove" value="{$lang->remove_avatar}" />') . '#', '<!-- DeleteAvatarButton -->');
	
	return TRUE;
}

/**
 * Deactivate plugin
 *
 * @return bool
 */
function default_avatar_deactivate()
{
	// Add "Delete Avatar" button
	require MYBB_ROOT . '/inc/adminfunctions_templates.php';

	find_replace_templatesets('usercp_avatar', '#<!--\sDeleteAvatarButton\s--\>#is', '<input type="submit" class="button" name="remove" value="{$lang->remove_avatar}" />', 0);
	return TRUE;
}

/**
 * Set a default avatar to all users
 *
 * @return bool
 */
function default_avatar_update_current_users()
{
	global $mybb, $db, $lang;
	
	$plugin_status = default_avatar_is_installed();
	
	if($mybb->input['defaultavatar'] == 'update_current_users' && $plugin_status)
	{
		$lang->load('default_avatar');
		
		$set_avatar = get_default_avatar_data();
		$db->update_query('users', $set_avatar, 'avatar = "" OR avatar = "images/avatars/clear_avatar.gif"');
		
		flash_message($lang->default_avatar_message_all_users_updated, 'success');
		admin_redirect('index.php?module=config-plugins');
		
		return TRUE;
	}
	
	return FALSE;
}

/**
 * Set default avatar on signup
 *
 * @return bool
 */
function default_avatar_onsignup()
{
	global $mybb, $db, $user_info;
	
	$set_avatar = get_default_avatar_data();
	
	$db->update_query('users', $set_avatar, 'uid = ' . $user_info['uid']);
	
	return true;
}

/**
 * Set default avatar when the user delete his current avatar
 *
 * @return bool
 */
function default_avatar_onchange()
{
	global $mybb, $db;
	
	if($mybb->input['remove'] OR ($mybb->input['gallery'] && $mybb->input['avatar'] == 'clear_avatar.gif'))
	{
		$set_avatar = get_default_avatar_data();
		
		$db->update_query('users', $set_avatar, 'uid = ' . $mybb->user['uid']);
	}
	
	return true;
}

/**
 * Get default avatar data from MyBB Settings
 *
 * @return array Avatar data
 */
function get_default_avatar_data()
{
	global $mybb;
	
	$avatar = array(
		'avatar' => $mybb->settings['default_avatar_url'],
		'avatardimensions' => $mybb->settings['default_avatar_width'] . '|' . $mybb->settings['default_avatar_height'],
		'avatartype' => 'remote'
	);
	
	return $avatar;
}